from JumpScale9Lib.clients.racktivity.energyswitch.common import convert
from JumpScale9Lib.clients.racktivity.energyswitch.common.GUIDTable import Value
from JumpScale9Lib.clients.racktivity.energyswitch.modelfactory.models.common.BaseModule import BaseModule


class Power(BaseModule):

    def __init__(self, parent):
        super(Power, self).__init__(parent)
        self._guidTable.update({
            # CurrentWarningEvent
            10078: Value(u"type='TYPE_EVENTFLAGS'\nsize=1\nlength=1\nunit=''\nscale=0"),
            # PowerWarningEvent
            10080: Value(u"type='TYPE_EVENTFLAGS'\nsize=1\nlength=1\nunit=''\nscale=0"),
            # TotalCurrentWarningEvent
            10082: Value(u"type='TYPE_EVENTFLAGS'\nsize=1\nlength=1\nunit=''\nscale=0"),
            # TotalPowerWarningEvent
            10084: Value(u"type='TYPE_EVENTFLAGS'\nsize=1\nlength=1\nunit=''\nscale=0"),
            # VoltageWarningEvent
            10086: Value(u"type='TYPE_EVENTFLAGS'\nsize=1\nlength=1\nunit=''\nscale=0"),
            # TemperatureWarningEvent
            10087: Value(u"type='TYPE_EVENTFLAGS'\nsize=1\nlength=1\nunit=''\nscale=0"),
        })

    # The pointer
    def getPowerPointer(self, moduleID):
        return self._getPointerData(moduleID)

    # CurrentWarningEvent
    def getCurrentWarningEvent(self, moduleID, portnumber=1):
        guid = 10078
        length = 1
        valDef = self._guidTable[guid]
        data = self._parent.client.getAttribute(
            moduleID, guid, portnumber, length)
        return self._parent.getObjectFromData(data, valDef, count=length)

    def setCurrentWarningEvent(self, moduleID, value, portnumber=1):
        guid = 10078
        valDef = self._guidTable[guid]
        data = self._parent.client.setAttribute(
            moduleID, guid, convert.value2bin(value, valDef), portnumber)
        return self._parent.getObjectFromData(data, valDef, setter=True)

    # PowerWarningEvent
    def getPowerWarningEvent(self, moduleID, portnumber=1):
        guid = 10080
        length = 1
        valDef = self._guidTable[guid]
        data = self._parent.client.getAttribute(
            moduleID, guid, portnumber, length)
        return self._parent.getObjectFromData(data, valDef, count=length)

    def setPowerWarningEvent(self, moduleID, value, portnumber=1):
        guid = 10080
        valDef = self._guidTable[guid]
        data = self._parent.client.setAttribute(
            moduleID, guid, convert.value2bin(value, valDef), portnumber)
        return self._parent.getObjectFromData(data, valDef, setter=True)

    # TotalCurrentWarningEvent
    def getTotalCurrentWarningEvent(self, moduleID):
        guid = 10082
        portnumber = 0
        length = 1
        valDef = self._guidTable[guid]
        data = self._parent.client.getAttribute(
            moduleID, guid, portnumber, length)
        return self._parent.getObjectFromData(data, valDef, count=length)

    def setTotalCurrentWarningEvent(self, moduleID, value):
        guid = 10082
        portnumber = 0
        valDef = self._guidTable[guid]
        data = self._parent.client.setAttribute(
            moduleID, guid, convert.value2bin(value, valDef), portnumber)
        return self._parent.getObjectFromData(data, valDef, setter=True)

    # TotalPowerWarningEvent
    def getTotalPowerWarningEvent(self, moduleID):
        guid = 10084
        portnumber = 0
        length = 1
        valDef = self._guidTable[guid]
        data = self._parent.client.getAttribute(
            moduleID, guid, portnumber, length)
        return self._parent.getObjectFromData(data, valDef, count=length)

    def setTotalPowerWarningEvent(self, moduleID, value):
        guid = 10084
        portnumber = 0
        valDef = self._guidTable[guid]
        data = self._parent.client.setAttribute(
            moduleID, guid, convert.value2bin(value, valDef), portnumber)
        return self._parent.getObjectFromData(data, valDef, setter=True)

    # VoltageWarningEvent
    def getVoltageWarningEvent(self, moduleID):
        guid = 10086
        portnumber = 0
        length = 1
        valDef = self._guidTable[guid]
        data = self._parent.client.getAttribute(
            moduleID, guid, portnumber, length)
        return self._parent.getObjectFromData(data, valDef, count=length)

    def setVoltageWarningEvent(self, moduleID, value):
        guid = 10086
        portnumber = 0
        valDef = self._guidTable[guid]
        data = self._parent.client.setAttribute(
            moduleID, guid, convert.value2bin(value, valDef), portnumber)
        return self._parent.getObjectFromData(data, valDef, setter=True)

    # TemperatureWarningEvent
    def getTemperatureWarningEvent(self, moduleID):
        guid = 10087
        portnumber = 0
        length = 1
        valDef = self._guidTable[guid]
        data = self._parent.client.getAttribute(
            moduleID, guid, portnumber, length)
        return self._parent.getObjectFromData(data, valDef, count=length)

    def setTemperatureWarningEvent(self, moduleID, value):
        guid = 10087
        portnumber = 0
        valDef = self._guidTable[guid]
        data = self._parent.client.setAttribute(
            moduleID, guid, convert.value2bin(value, valDef), portnumber)
        return self._parent.getObjectFromData(data, valDef, setter=True)
